/**********************************************************************
 * Copyright (c) 2009  Red Hat, Inc.
 *
 * File: precomp.h
 *
 * Author(s):
 *
 * This file contains trace and debugging related definitions
 *
 * This work is licensed under the terms of the GNU GPL, version 2.  See
 * the COPYING file in the top-level directory.
 *
**********************************************************************/
#include <evntrace.h>

#if !defined(EVENT_TRACING)

#include "kdebugprint.h"

extern ULONG driverDebugFlags;
extern int driverDebugLevel;

#if !defined(TRACE_LEVEL_NONE)
  #define TRACE_LEVEL_NONE        0
  #define TRACE_LEVEL_FATAL       1
  #define TRACE_LEVEL_ERROR       2
  #define TRACE_LEVEL_WARNING     3
  #define TRACE_LEVEL_INFORMATION 4
  #define TRACE_LEVEL_VERBOSE     5
  #define TRACE_LEVEL_RESERVED6   6
  #define TRACE_LEVEL_RESERVED7   7
  #define TRACE_LEVEL_RESERVED8   8
  #define TRACE_LEVEL_RESERVED9   9
#endif


//
// Define Debug Flags
//
#define DBG_INIT                0x00000001
#define DBG_PNP                 0x00000002
#define DBG_POWER               0x00000004
#define DBG_WMI                 0x00000008
#define DBG_CREATE_CLOSE        0x00000010
#define DBG_IOCTLS              0x00000020
#define DBG_WRITE               0x00000040
#define DBG_READ                0x00000080
#define DBG_DPC                 0x00000100
#define DBG_INTERRUPT           0x00000200
#define DBG_LOCKS               0x00000400
#define DBG_QUEUEING            0x00000800
#define DBG_HW_ACCESS           0x00001000

#define TraceEvents(level, flags, message, ...) \
if (level > driverDebugLevel || !bDebugPrint || !(driverDebugFlags & flags)) {} \
else VirtioDebugPrintProc(message, __VA_ARGS__)

void InitializeDebugPrints(IN PDRIVER_OBJECT  DriverObject, PUNICODE_STRING RegistryPath);

#define WPP_INIT_TRACING InitializeDebugPrints
#define WPP_CLEANUP(DriverObject)

#else
#define WPP_CHECK_FOR_NULL_STRING

#define WPP_CONTROL_GUIDS \
    WPP_DEFINE_CONTROL_GUID(BalloonTraceGuid,(08cb9471,36fb,46ee,998b,d1bfbe1c4899), \
        WPP_DEFINE_BIT(DBG_INIT)             /* bit  0 = 0x00000001 */ \
        WPP_DEFINE_BIT(DBG_PNP)              /* bit  1 = 0x00000002 */ \
        WPP_DEFINE_BIT(DBG_POWER)            /* bit  2 = 0x00000004 */ \
        WPP_DEFINE_BIT(DBG_WMI)              /* bit  3 = 0x00000008 */ \
        WPP_DEFINE_BIT(DBG_CREATE_CLOSE)     /* bit  4 = 0x00000010 */ \
        WPP_DEFINE_BIT(DBG_IOCTLS)           /* bit  5 = 0x00000020 */ \
        WPP_DEFINE_BIT(DBG_WRITE)            /* bit  6 = 0x00000040 */ \
        WPP_DEFINE_BIT(DBG_READ)             /* bit  7 = 0x00000080 */ \
        WPP_DEFINE_BIT(DBG_DPC)              /* bit  8 = 0x00000100 */ \
        WPP_DEFINE_BIT(DBG_INTERRUPT)        /* bit  9 = 0x00000200 */ \
        WPP_DEFINE_BIT(DBG_LOCKS)            /* bit 10 = 0x00000400 */ \
        WPP_DEFINE_BIT(DBG_QUEUEING)         /* bit 11 = 0x00000800 */ \
        WPP_DEFINE_BIT(DBG_HW_ACCESS)        /* bit 12 = 0x00001000 */ \
        )

#define WPP_LEVEL_FLAGS_LOGGER(lvl,flags) WPP_LEVEL_LOGGER(flags)
#define WPP_LEVEL_FLAGS_ENABLED(lvl, flags) (WPP_LEVEL_ENABLED(flags) && WPP_CONTROL(WPP_BIT_ ## flags).Level  >= lvl)

#endif


